/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.steps;

import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWStepProcessorInfoDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.canvas.process.VWDesignerBasePropertyPanel;
import filenet.vw.toolkit.design.canvas.process.VWPropertyMenuItem;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.event.IVWCoordinationEventListener;
import filenet.vw.toolkit.design.property.event.VWCoordinationEvent;
import filenet.vw.toolkit.design.property.steps.IVWGeneralStepPropertyTabs;
import filenet.vw.toolkit.design.property.steps.VWBaseStepPropertiesPanel;
import filenet.vw.toolkit.utils.VWDataDictionary;
import filenet.vw.toolkit.utils.VWStepUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.Beans;
import javax.swing.Icon;

public class VWStepPropertyPanel
extends VWDesignerBasePropertyPanel
implements IVWCoordinationEventListener {
    protected static final String READONLY_STEP_PROPERTIES_PANEL = "filenet.vw.toolkit.design.property.steps.VWReadOnlyStepPropertiesPanel";
    protected VWBaseStepPropertiesPanel m_currentPropertyPanel = null;
    protected VWMapNode m_selectedMapNode = null;

    public VWStepPropertyPanel(VWAuthPropertyData authPropertyData) {
        super(authPropertyData);
        this.m_authPropertyData.getDesignerCoreData().getCoordinationEventNotifier().addCoordinationEventListener(this);
    }

    public Object getDataObject() {
        return this.m_selectedMapNode;
    }

    public void setDataObject(Object dataObject) {
        if (dataObject == null || !(dataObject instanceof VWMapNode) || dataObject == this.m_selectedMapNode) {
            return;
        }
        this.m_selectedMapNode = (VWMapNode)dataObject;
        this.changeTabsPanel();
    }

    public String getDisplayName() {
        String name = this.getToolTip();
        if (name != null) {
            name = this.getFormattedTabName(name);
        }
        return name;
    }

    public String getToolTip() {
        if (this.m_selectedMapNode != null) {
            return VWPropertyMenuItem.getDisplayName(this.m_selectedMapNode);
        }
        return null;
    }

    public Icon getIcon() {
        return VWStepUtils.getStepIcon(this.m_selectedMapNode, this.m_authPropertyData.getSessionInfo());
    }

    public void displayHelpPage() {
        this.m_currentPropertyPanel.displayHelpPage();
    }

    public void releaseReferences() {
        this.m_authPropertyData.getDesignerCoreData().getCoordinationEventNotifier().removeCoordinationEventListener(this);
        if (this.m_currentPropertyPanel != null) {
            this.m_currentPropertyPanel.releaseReferences();
            this.m_currentPropertyPanel = null;
        }
        super.releaseReferences();
    }

    public void handleCoordinationEvent(VWCoordinationEvent event) {
        switch (event.getID()) {
            case 765: {
                this.updateStepProcessors();
                break;
            }
            case 757: {
                this.changeTabsPanel();
            }
        }
    }

    protected void createControls() {
        try {
            this.removeAll();
            this.setLayout(new BorderLayout());
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void changeTabsPanel() {
        String panelClassName = null;
        try {
            if (this.m_selectedMapNode != null) {
                panelClassName = VWStepUtils.getStepPropertiesPanelClassName(this.m_selectedMapNode);
                boolean isMapEditable = this.m_authPropertyData.isCurrentMapEditable();
                if (!isMapEditable || panelClassName == null || panelClassName.length() == 0) {
                    panelClassName = this.getStandardStepPropertiesPanelClassName();
                }
                if (this.m_currentPropertyPanel != null) {
                    this.remove(this.m_currentPropertyPanel);
                    this.m_currentPropertyPanel.releaseReferences();
                    this.m_currentPropertyPanel = null;
                }
                this.m_currentPropertyPanel = this.loadPropertiesPanel(panelClassName);
                this.add((Component)this.m_currentPropertyPanel, "Center");
                this.updateStepProcessors();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateStepProcessors() {
        if (this.m_currentPropertyPanel instanceof IVWGeneralStepPropertyTabs) {
            IVWGeneralStepPropertyTabs generalPropertyTabs = (IVWGeneralStepPropertyTabs)((Object)this.m_currentPropertyPanel);
            VWDataDictionary dataDictionary = this.m_authPropertyData.getDesignerCoreData().getDataDictionary();
            switch (VWStepUtils.getStepType(this.m_selectedMapNode)) {
                case 0: {
                    VWStepProcessorInfoDefinition[] launchStepProcessors = dataDictionary.getStepProcessors(0);
                    VWStepProcessorInfoDefinition defaultLaunchStepProcessor = dataDictionary.getDefaultStepProcessor(0);
                    generalPropertyTabs.setStepProcessors(launchStepProcessors, defaultLaunchStepProcessor);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    VWStepProcessorInfoDefinition[] regularStepProcessors = dataDictionary.getStepProcessors(1);
                    VWStepProcessorInfoDefinition defaultRegularStepProcessor = dataDictionary.getDefaultStepProcessor(1);
                    generalPropertyTabs.setStepProcessors(regularStepProcessors, defaultRegularStepProcessor);
                    break;
                }
            }
        }
    }

    private String getStandardStepPropertiesPanelClassName() {
        String panelClassName = null;
        if (this.m_authPropertyData.isCurrentMapEditable()) {
            switch (VWStepUtils.getStepType(this.m_selectedMapNode)) {
                case 0: {
                    panelClassName = "filenet.vw.toolkit.design.property.steps.VWLaunchStepPropertyTabs";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    panelClassName = "filenet.vw.toolkit.design.property.steps.VWGeneralStepPropertyTabs";
                    break;
                }
                case 9: 
                case 10: {
                    panelClassName = "filenet.vw.toolkit.design.property.steps.VWSubmapStepPropertyTabs";
                    break;
                }
                case 11: 
                case 12: {
                    panelClassName = "filenet.vw.toolkit.design.property.steps.VWSystemStepPropertyTabs";
                    break;
                }
                case 13: 
                case 14: {
                    panelClassName = "filenet.vw.toolkit.design.property.steps.VWComponentStepPropertyTabs";
                }
            }
        } else {
            panelClassName = READONLY_STEP_PROPERTIES_PANEL;
        }
        return panelClassName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private VWBaseStepPropertiesPanel loadPropertiesPanel(String panelClassName) {
        Component panel;
        block11: {
            panel = null;
            this.m_authPropertyData.displayWaitCursor(this);
            try {
                try {
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    Object loadObj = Beans.instantiate(classLoader, panelClassName);
                    if (loadObj != null && loadObj instanceof VWBaseStepPropertiesPanel) {
                        panel = (VWBaseStepPropertiesPanel)loadObj;
                        ((VWBaseStepPropertiesPanel)panel).init(this.m_authPropertyData, this.m_selectedMapNode);
                    } else {
                        panelClassName = this.getStandardStepPropertiesPanelClassName();
                        panel = this.loadPropertiesPanel(panelClassName);
                    }
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    Object var6_7 = null;
                    if (panel != null && panel instanceof Component) {
                        panel.applyComponentOrientation(this.getComponentOrientation());
                    }
                    this.m_authPropertyData.restoreDefaultCursor(this);
                    return panel;
                }
                Object var6_6 = null;
                if (panel == null) break block11;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (panel != null && panel instanceof Component) {
                    panel.applyComponentOrientation(this.getComponentOrientation());
                }
                this.m_authPropertyData.restoreDefaultCursor(this);
                throw throwable;
            }
            if (panel instanceof Component) {
                panel.applyComponentOrientation(this.getComponentOrientation());
            }
        }
        this.m_authPropertyData.restoreDefaultCursor(this);
        return panel;
    }
}

